(function () {
  if (typeof PCC_ADMIN === "undefined") return;

  var canvas = document.getElementById("pccChart");
  if (!canvas) return;

  var labels = PCC_ADMIN.labels || [];
  var values = PCC_ADMIN.values || [];

  // Chart.js
  new Chart(canvas, {
    type: "line",
    data: {
      labels: labels,
      datasets: [
        {
          label: "Clics sur tel:",
          data: values,
          tension: 0.25,
          fill: false,
        },
      ],
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: true },
        tooltip: { enabled: true },
      },
      scales: {
        y: { beginAtZero: true, ticks: { precision: 0 } },
      },
    },
  });
})();
